#include "stdafx.h"
#include "frame1.h" //Log and comments are in the header.

Frame::Frame(Real radiusx, Real radiusy)
{
	_realradiusx = radiusx;
	_realradiusy = radiusy;
/* Force some numbers in to be safe, though normally you'll
call SetPixelWindow again in the initial WM_SIZE with
the actual size of your active window. */
	SetPixelWindow(600, 480);
	_changed_size_flag = TRUE;
	_fixed_aspect_flag = FALSE;
}

void Frame::_fixup_constants()
{ /* Precompute the four constants used in RealToPixel and
turn on the _changed_size_flag so that anyone using this Frame
object will know that any RealToPixel computation results they've
stored must now be redone. */
	_realpixperx = (Real)_midx/_realradiusx;
	_realpixpery = (Real)_midy/_realradiusy;
	if (_fixed_aspect_flag)
	{
		if (_realpixperx < _realpixpery)
			_realpixpery = _realpixperx;
		else
			_realpixperx = _realpixpery;
	}
	_constx = _midx - _realcenterx * _realpixperx;
	_consty = _midy + _realcentery * _realpixpery;
	_changed_size_flag = TRUE;
}

void Frame::SetPixelWindow(int cx, int cy)
{
	_cx = cx;
	_cy = cy;
	_midx = cx/2;
	_midy = cy/2;
	_fixup_constants();
}

void Frame::SetFixedAspect(BOOL truefalse)
{
	_fixed_aspect_flag = truefalse;
	_fixup_constants();
}

void Frame::SetRealWindow(Real lox, Real loy, Real hix, Real hiy)
{
	_realcenterx = (lox + hix) / 2.0; //Average the values
	_realcentery = (loy + hiy) / 2.0; //Average to get the center.
	_realradiusx = hix - _realcenterx;
	_realradiusy = hiy - _realcentery;
	_fixup_constants();
}

#define INTEGER_OVERFLOW 32000.0
BOOL Frame::RealToPixel(Real rx, Real ry, int *ix, int *iy) const
{ /*Designed to match the centers of the 2 windows even if
_fixed_aspect_flag.  Originally, we had the more obvious
	tempx = _midx + (rx - _realcenterx) * _realpixperx;
	tempy = _midy - (ry - _realcentery) * _realpixpery;
But to speed it up, we precompute _midx/_realradiusx
as _realpixperx and we precompute 
_midx -_realcenterx*_realpixperx as constx, so now
tempx = constx + rx*_realpixperx.  Note that you have
to recompute these constants whenever you change the window
sizes. Another thing we do here is to not allow integers
that might overflow a register. */
	Real tempx, tempy;
	tempx = _constx + rx * _realpixperx;
	tempy = _consty - ry * _realpixpery;
	if (tempx > INTEGER_OVERFLOW || tempy > INTEGER_OVERFLOW ||
		tempx < -INTEGER_OVERFLOW || tempy < -INTEGER_OVERFLOW)
		return FALSE; //integer would be out of range and meaningless.
	*ix = (int)tempx;
	*iy = (int)tempy;
	return TRUE;
}

void Frame::PixelToReal( int ix, int iy, Real *rx, Real *ry) const
{
	*rx = ((Real)(ix - _midx)/_realpixperx) + _realcenterx;
	*ry = ((Real)(_midy - iy)/_realpixpery) + _realcentery;
}

void Frame::Zoom(Real newcenterx, Real newcentery, Real zoomfactor)
{
	_realcenterx = newcenterx;
	_realcentery = newcentery;
	_realradiusx *= zoomfactor;
	_realradiusy *= zoomfactor;
	_fixup_constants();
}

void Frame::ZoomAtPixel(int pixx, int pixy, Real zoomfactor)
{
	Real newcenterx, newcentery;
	PixelToReal(pixx, pixy, &newcenterx, &newcentery);
	Zoom(newcenterx, newcentery, zoomfactor);
}
